/*
 * Decompiled with CFR 0.152.
 */
package pub.pigeon.yggdyy.hexcreating.create.ponder;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.api.casting.math.HexAngle;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.lib.HexBlocks;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.element.TextWindowElement;
import com.simibubi.create.foundation.ponder.instruction.PonderInstruction;
import com.simibubi.create.foundation.ponder.instruction.TextInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;
import pub.pigeon.yggdyy.hexcreating.mixins.SceneBuilderAccessor;
import pub.pigeon.yggdyy.hexcreating.mixins.TextWindowElementAccessor;

public class HexPonderUtils {
    public static final int A_LONG_TIME = 12000;

    public static class PatternDisplay {
        private SceneBuilder scene;
        private SceneBuildingUtil util;
        private class_243 o;
        private class_243 x;
        private class_243 y;
        private class_243 z;
        private List<ArrowDisplay> strokes = new ArrayList<ArrowDisplay>();
        private static double Y_DELTA = Math.sqrt(3.0) / 2.0;
        private static int M = 6;
        private static Map<Integer, class_3545<Double, Double>> INDEX2OFFSET = Map.of(0, new class_3545((Object)0.5, (Object)Y_DELTA), 1, new class_3545((Object)1.0, (Object)0.0), 2, new class_3545((Object)0.5, (Object)(-Y_DELTA)), 3, new class_3545((Object)-0.5, (Object)(-Y_DELTA)), 4, new class_3545((Object)-1.0, (Object)0.0), 5, new class_3545((Object)-0.5, (Object)Y_DELTA));
        private static Map<HexDir, Integer> DIR2INDEX = Map.of(HexDir.NORTH_EAST, 0, HexDir.EAST, 1, HexDir.SOUTH_EAST, 2, HexDir.SOUTH_WEST, 3, HexDir.WEST, 4, HexDir.NORTH_WEST, 5);
        private static Map<HexAngle, Integer> ANGLE2INDEX = Map.of(HexAngle.FORWARD, 0, HexAngle.RIGHT, 1, HexAngle.RIGHT_BACK, 2, HexAngle.BACK, 3, HexAngle.LEFT_BACK, 4, HexAngle.LEFT, 5);

        public PatternDisplay(SceneBuilder scene, SceneBuildingUtil util, class_243 origin, class_243 xDelta, class_243 yDelta, HexPattern pattern) {
            this.o = origin;
            this.x = xDelta;
            this.y = yDelta;
            this.z = this.x.method_1036(this.y);
            this.scene = scene;
            this.util = util;
            class_243 nowPos = this.o;
            int nowIndex = DIR2INDEX.get(pattern.getStartDir());
            this.strokes.add(new ArrowDisplay(scene, util).start(nowPos).end(nowPos.method_1019(this.makeVec3(INDEX2OFFSET.get(nowIndex))).method_1019(this.z.method_1021(0.01))).size(this.x.method_1033() / 16.0));
            nowPos = nowPos.method_1019(this.makeVec3(INDEX2OFFSET.get(nowIndex)));
            for (HexAngle i : pattern.getAngles()) {
                nowIndex = (nowIndex + ANGLE2INDEX.get(i)) % M;
                this.strokes.add(new ArrowDisplay(scene, util).start(nowPos).end(nowPos.method_1019(this.makeVec3(INDEX2OFFSET.get(nowIndex))).method_1019(this.z.method_1021(0.01))).size(this.x.method_1033() / 16.0));
                nowPos = nowPos.method_1019(this.makeVec3(INDEX2OFFSET.get(nowIndex)));
            }
        }

        private class_243 makeVec3(double _x, double _y) {
            return this.x.method_1021(_x).method_1019(this.y.method_1021(_y));
        }

        private class_243 makeVec3(class_3545<Double, Double> pair) {
            return this.makeVec3((Double)pair.method_15442(), (Double)pair.method_15441());
        }

        public void show(int duration, int per, List<PonderPalette> colors) {
            if (this.strokes.size() == 0) {
                return;
            }
            if (colors.size() == 0) {
                this.show(duration, per, List.of(PonderPalette.FAST));
                return;
            }
            if (per < 0 || per * this.strokes.size() >= duration) {
                this.show(duration, duration / this.strokes.size(), colors);
                return;
            }
            for (int i = 0; i < this.strokes.size(); ++i) {
                PonderPalette nowColor = i < colors.size() ? colors.get(i) : colors.get(colors.size() - 1);
                this.strokes.get(i).color(nowColor, nowColor).show(duration - i * per);
                this.scene.idle(per);
            }
        }

        public void show(int duration, int per, PonderPalette color) {
            this.show(duration, per, List.of(color));
        }

        public void show(int duration, List<PonderPalette> colors) {
            this.show(duration, 0, colors);
        }

        public void show(int duration, PonderPalette color) {
            this.show(duration, 0, List.of(color));
        }

        public void show(int duration, int per) {
            this.show(duration, per, List.of(PonderPalette.GREEN, PonderPalette.FAST));
        }

        public void show(int duration) {
            this.show(duration, 0);
        }
    }

    public static class ArrowDisplay {
        public SceneBuilder scene;
        public SceneBuildingUtil util;
        public class_243 startPos = class_243.field_1353;
        public class_243 endPos = new class_243(0.0, 1.0, 0.0);
        public double headSize = 1.0;
        public PonderPalette baseColor = PonderPalette.WHITE;
        public PonderPalette headColor = PonderPalette.WHITE;

        public ArrowDisplay(SceneBuilder scene, SceneBuildingUtil util) {
            this.scene = scene;
            this.util = util;
        }

        public ArrowDisplay start(class_243 vec) {
            this.startPos = vec;
            return this;
        }

        public ArrowDisplay end(class_243 vec) {
            this.endPos = vec;
            return this;
        }

        public ArrowDisplay size(double head) {
            this.headSize = head;
            return this;
        }

        public ArrowDisplay color(PonderPalette base, PonderPalette head) {
            this.baseColor = base;
            this.headColor = head;
            return this;
        }

        public void show(int duration) {
            this.scene.overlay.showLine(this.baseColor, this.startPos, this.endPos, duration);
            if (this.headSize <= 0.0) {
                return;
            }
            class_243 delta = this.endPos.method_1019(this.startPos.method_1021(-1.0));
            class_243 f = delta.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029().method_1021(this.headSize);
            if (delta.method_1029().method_1026(new class_243(0.0, 1.0, 0.0)) == 1.0) {
                f = new class_243(1.0, 0.0, 0.0).method_1021(this.headSize);
            }
            class_243 preHead = delta.method_1021(this.headSize / delta.method_1033() * -1.0);
            class_243 head1 = preHead.method_1019(f);
            class_243 head2 = preHead.method_1019(f.method_1021(-1.0));
            this.scene.overlay.showLine(this.headColor, this.endPos.method_1019(head1), this.endPos, duration);
            this.scene.overlay.showLine(this.headColor, this.endPos, this.endPos.method_1019(head2), duration);
        }
    }

    public static class StackDisplay {
        public SceneBuilder scene;
        public SceneBuildingUtil util;
        private ArrayList<IotaDisplay> iotas = new ArrayList();
        private class_2338 basePos;

        public StackDisplay(SceneBuilder scene, SceneBuildingUtil util, class_2338 basePos) {
            this.scene = scene;
            this.util = util;
            this.basePos = basePos;
        }

        public void push(Iota iota, int textDuration) {
            class_2338 pos = this.basePos.method_10086(this.iotas.size() + 1);
            IotaDisplay display = new IotaDisplay(this.scene, this.util, iota);
            display.setPos(pos);
            display.showIota(textDuration);
            this.iotas.add(display);
        }

        public void pop() {
            if (this.iotas.size() == 0) {
                return;
            }
            this.iotas.get(this.iotas.size() - 1).hideIota();
            this.iotas.remove(this.iotas.size() - 1);
        }

        public Iota top(int rId) {
            if (0 < rId && rId <= this.iotas.size()) {
                return this.iotas.get((int)(this.iotas.size() - rId)).iota;
            }
            return new NullIota();
        }

        public Iota top() {
            return this.top(1);
        }

        public class_243 tipPos(int rId) {
            int offset = this.iotas.size() - rId + 1;
            return this.util.vector.blockSurface(this.basePos.method_10086(offset), class_2350.field_11039).method_1031(0.0, 0.25, 0.0);
        }
    }

    public static class IotaDisplay {
        public SceneBuilder scene;
        public SceneBuildingUtil util;
        public Iota iota;
        @Nullable
        private class_2338 nowPos;

        public IotaDisplay(SceneBuilder scene, SceneBuildingUtil util, Iota iota) {
            this.scene = scene;
            this.util = util;
            this.iota = iota;
        }

        public void setPos(class_2338 pos) {
            this.nowPos = pos;
        }

        public void showIota(int predictedDuration) {
            TextWindowElement iotaText;
            if (this.nowPos == null) {
                return;
            }
            this.scene.world.setBlock(this.nowPos, this.getBookshelfState(), false);
            this.scene.world.modifyBlockEntity(this.nowPos, BlockEntityAkashicBookshelf.class, be -> be.setNewMapping(this.getPattern(), this.iota));
            this.scene.world.showSection(this.util.select.position(this.nowPos), class_2350.field_11033);
            TextWindowElement textWindowElement = iotaText = new TextWindowElement();
            Objects.requireNonNull(textWindowElement);
            TextWindowElement.Builder iotaTextBuilder = new TextWindowElement.Builder(textWindowElement, ((SceneBuilderAccessor)this.scene).getScene());
            iotaTextBuilder.pointAt(this.util.vector.blockSurface(this.nowPos, class_2350.field_11043).method_1031(0.0, -0.25, 0.0)).placeNearTarget().colored(this.getColor());
            ((TextWindowElementAccessor)iotaText).setTextGetter(() -> this.iota.display().getString());
            this.scene.addInstruction((PonderInstruction)new TextInstruction(iotaText, predictedDuration));
        }

        public void hideIota() {
            if (this.nowPos == null) {
                return;
            }
            this.scene.world.hideSection(this.util.select.position(this.nowPos), class_2350.field_11036);
        }

        private class_2680 getBookshelfState() {
            return (class_2680)HexBlocks.AKASHIC_BOOKSHELF.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043);
        }

        private HexPattern getPattern() {
            return HexPattern.fromAngles((String)"w", (HexDir)HexDir.EAST);
        }

        private PonderPalette getColor() {
            return PonderPalette.WHITE;
        }
    }
}

